\name{makeChipPackage}

\alias{makeChipPackage}


\title{
  Making a chip package from annotations available from data.frame of
  probes mapped to gene IDs and an existing org package.
}
\description{
  The \code{makeChipPackage} function allows the user to make an
  chip package from a data.frame that has two columns to define a set of
  probes and the gene IDs that they map to as well as an org package
  that contains data about those gene IDs (where the gene IDs can be
  used as a foreign key).

  \code{makeChipPackage} is intended to be compatible with any org
  packages that are generated by \code{makeOrgPackage} as well as most
  of the older legacy org packages that were based on more popular model
  organisms.  The one exception is the legacy org package for yeast
  \code{org.Sc.sgd.db} since its internal schema is just too different
  from everything else.

  Packages produced in this way can not support the older bimap objects
  unless they are pointing to an older legacy org package.  All packages
  should support select().
}
\usage{

  makeChipPackage(prefix,
                  probeFrame, 
                  orgPkgName, 
                  version,
                  maintainer,
                  author,
                  outputDir = ".",
                  tax_id,
                  genus,
                  species,
                  optionalAccessionsFrame=NULL)
}


\arguments{
  \item{prefix}{The package name}
  \item{probeFrame}{data.frame with two columns.  The 1st column are the
  probes and the second column are genes (gene IDs).  The gene IDs must
  be the main ID type for the org package that is the named in the 3rd
  argument.}
  \item{orgPkgName}{The name of the org package that you want to make
  the chip package to go with}
  \item{version}{What is the version number for this package? format: \'x.y.z\'}
  \item{maintainer}{Who is the package maintainer? (must include email to be 
    valid)}
  \item{author}{Who is the creator of this package?}
  \item{outputDir}{A path where the package source should be assembled.}
  \item{tax_id}{The Taxonomy ID that represents your organism.  (NCBI has
  a nice online browser for finding the one you need)}
  \item{genus}{Single string indicating the genus.}
  \item{species}{Single string indicating the species.}
  \item{optionalAccessionsFrame}{If you want to also include accessions
  for your probes (not used for mapping them) then you can include those
  here.}
}


\value{The path to the package that just created. This is useful for
  calling install.packages as the next step.}

\author{
  M. Carlson
}


\examples{

if(interactive()){
## 1st lets list some authentic entrez gene IDs
geneIds <- c("1","10","100","1000","10000","100008586")
probeNames <- paste("probe", 1:length(geneIds), sep="")
probeFrame <- data.frame(probes=probeNames, genes=geneIds)

makeChipPackage(prefix='testChip',
                probeFrame=probeFrame,
                orgPkgName='org.Hs.eg.db',
                version='0.99.1',
                maintainer='Some One <so@someplace.org>',
                author='Some One <so@someplace.org>',
                outputDir='.',
                tax_id='59729',
                genus='Homo',
                species='sapiens')

## then you can call install.packages based on the return value
install.packages('./testChip.db', repos=NULL)

}

}
